var dom = {};
var data = [
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
];
var answers = [
  {
    txt: 'manger',
    example: '',
  },
  {
    txt: 'exprimer ses émotions',
    example: ')',
  },
  {
    txt: 'respecter des codes de politesse',
    example: '',
  },
  {
    txt: 'imitation',
    example: '',
  },
  {
    txt: 'sanction (positives ou négatives // fortes ou non)',
    example: ')',
  },
  {
    txt: 'échanges',
    example: '',
  },
  {
    txt: 'être capable de comprendre les autres',
    example: '',
  },
  {
    txt: 'être capable d’échanger avec les autres',
    example: ')',
  },
];

var _line1 = null;
var _line2 = null;
var _line3 = null;
var _line4 = null;

/** MINDMAP LINE */
var optionLine = {
  path: 'straight',
  startPlug: 'behind',
  endPlug: 'arrow2',
};
function initDom() {
  dom.appContent = document.getElementById('app-content_content');
  dom.appHeader = document.getElementById('app-content_header');
  dom.col_1_bloc_1 = document.getElementById('col-1-bloc-1');
  dom.col_2_bloc_1 = document.getElementById('col-2-bloc-1');
  dom.col_2_bloc_2 = document.getElementById('col-2-bloc-2');
  dom.col_3_bloc_1 = document.getElementById('col-3-bloc-1');
  dom.col_4 = document.getElementById('col-4');

  dom.col_2_bloc_gosth = document.getElementById('col-2-bloc-gost');
  dom.contenteditable_1 = document.getElementById('contenteditable-1');
  dom.contenteditable_2 = document.getElementById('contenteditable-2');
  dom.contenteditable_3 = document.getElementById('contenteditable-3');
  dom.contenteditable_4 = document.getElementById('contenteditable-4');
  dom.contenteditable_5 = document.getElementById('contenteditable-5');
  dom.contenteditable_6 = document.getElementById('contenteditable-6');
  dom.contenteditable_7 = document.getElementById('contenteditable-7');
  dom.contenteditable_8 = document.getElementById('contenteditable-8');
  dom.info = document.getElementById('info');
  dom.centerBloc = document.getElementById('col-2');
  dom.valid = document.getElementById('valid');
  dom.answer = document.getElementById('answer');
}

function createLines() {
  _line1 = new LeaderLine(
    LeaderLine.pointAnchor(dom.col_1_bloc_1, {
      x: '100%',
      y: '50%',
    }),

    LeaderLine.pointAnchor(dom.col_2_bloc_1, {
      x: '0%',
      y: '50%',
    }),
    {
      ...optionLine,
      startLabel: 'qui sont intériorisées ...',
    }
  );

  _line2 = new LeaderLine(
    LeaderLine.pointAnchor(dom.col_2_bloc_1, {
      x: '100%',
      y: '50%',
    }),

    LeaderLine.pointAnchor(dom.col_2_bloc_2, {
      x: '0%',
      y: '50%',
    }),
    {
      ...optionLine,
      startLabel: 'et permettent de ...',
    }
  );
}

function mergeObjects(obj1, obj2) {
  var mergedObj = {};

  for (var prop in obj1) {
    if (obj1.hasOwnProperty(prop)) {
      mergedObj[prop] = obj1[prop];
    }
  }

  for (var prop in obj2) {
    if (obj2.hasOwnProperty(prop)) {
      mergedObj[prop] = obj2[prop];
    }
  }

  return mergedObj;
}

function toggleValid(isShow) {
  if (isShow) {
    dom.valid.classList.remove('hide');
  } else {
    dom.valid.classList.add('hide');
  }
}

function updateData(index, value, type) {
  _line1.position();
  _line2.position();

  data[index].txt = value;

  var nb = 0;
  for (var i = 0; i < data.length; i++) {
    if (data[i].txt !== '') {
      nb += 1;
    }
  }
  if (nb === 8) {
    toggleValid(true);
  } else {
    toggleValid(false);
  }
}

function showAnswer() {
  dom.answer.classList.add('hide');
  dom.valid.classList.remove('hide');
  dom.contenteditable_1.innerHTML = data[0].txt;
  dom.contenteditable_2.innerHTML = data[1].txt;
  dom.contenteditable_3.innerHTML = data[2].txt;
  dom.contenteditable_4.innerHTML = data[3].txt;
  dom.contenteditable_5.innerHTML = data[4].txt;
  dom.contenteditable_6.innerHTML = data[5].txt;
  dom.contenteditable_7.innerHTML = data[6].txt;
  dom.contenteditable_8.innerHTML = data[7].txt;
}

function showCorrection() {
  dom.answer.classList.remove('hide');
  dom.valid.classList.add('hide');
  var elts = document.querySelectorAll('div[contenteditable]');

  for (var i = 0; i < elts.length; i++) {
    elts[i].setAttribute('contenteditable', false);
  }
  dom.contenteditable_1.innerHTML = answers[0].txt;
  dom.contenteditable_2.innerHTML = answers[1].txt;
  dom.contenteditable_3.innerHTML = answers[2].txt;
  dom.contenteditable_4.innerHTML = answers[3].txt;
  dom.contenteditable_5.innerHTML = answers[4].txt;
  dom.contenteditable_6.innerHTML = answers[5].txt;
  dom.contenteditable_7.innerHTML = answers[6].txt;
  dom.contenteditable_8.innerHTML = answers[7].txt;
}

function initEvent() {
  dom.contenteditable_1.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_2.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_3.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_4.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_5.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_6.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_7.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_8.addEventListener('input', function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });

  dom.answer.addEventListener('click', function () {
    showAnswer();
  });

  dom.valid.addEventListener('click', function () {
    showCorrection();
  });
  dom.contenteditable_1.focus();
}

function initApp() {
  initDom();

  initEvent();
  createLines();

  dom.info.classList.remove('hide');
}

window.addEventListener('load', initApp);
